/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class GTableCellRenderer implements TableCellRenderer {
    // -----------------------------------------------------
    class ChildIcon implements Icon {

        /**
         * copied from BasicTreeUI
         * @param g
         * @param y
         * @param x1
         * @param x2
         */
        private void drawDashedHorizontalLine(Graphics g, int y, int x1,
                int x2) {
            // assumes x1 <= x2
            // Drawing only even coordinates helps join line segments so they
            // appear as one line. This can be defeated by translating the
            // Graphics by an odd amount.
            x1 += (x1 % 2);

            for (int x = x1; x <= x2; x += 2) {
                g.drawLine(x, y, x, y);
            }
        }

        /**
         * copied from BasicTreeUI
         * @param g
         * @param y
         * @param x1
         * @param x2
         */
        private void drawDashedVerticalLine(Graphics g, int x, int y1, int y2) {
            // assumes y1 <= y2
            // Drawing only even coordinates helps join line segments so they
            // appear as one line. This can be defeated by translating the
            // Graphics by an odd amount.
            y1 += (y1 % 2);

            for (int y = y1; y <= y2; y += 2) {
                g.drawLine(x, y, x, y);
            }
        }

        /*
         * (Kein Javadoc)
         * 
         * @see javax.swing.Icon#getIconHeight()
         */
        public int getIconHeight() {
            return getDefaultLeafIcon().getIconHeight();
        }

        /*
         * (Kein Javadoc)
         * 
         * @see javax.swing.Icon#getIconWidth()
         */
        public int getIconWidth() {
            return getDefaultLeafIcon().getIconWidth();
        }

        /*
         * (Kein Javadoc)
         * 
         * @see javax.swing.Icon#paintIcon(java.awt.Component,
         *      java.awt.Graphics, int, int)
         */
        public void paintIcon(Component inpC, Graphics inpG, int inpX, int inpY) {
            int height = getIconHeight();
            int width = getIconWidth();
            int x1 = inpX + (width / 2);
            int y1 = inpY;
            int y2 = y1 + height - 5;
            Color tmpColor = inpG.getColor();
            inpG.setColor(Color.black);
            drawDashedVerticalLine(inpG, x1, y1, y2);
            int x2 = x1 + (width / 2);
            drawDashedHorizontalLine(inpG, y2, x1, x2);
            inpG.setColor(tmpColor);
        }

    }

    // -----------------------------------------------------
    // Icons
    /** Icon used to show non-leaf nodes that aren't expanded. */
    transient protected Icon collapsedIcon;

    /** Icon used to show leaf nodes. */
    transient protected Icon leafIcon;

    transient protected Icon defaultLeafIcon;

    /** Icon used to show non-leaf nodes that are expanded. */
    transient protected Icon expandedIcon;

    private StringBuffer aStringBuffer = null;

    private JLabel aLabel = null;

    private Color lightBlue = new Color(160, 160, 255);

    private Color darkBlue = new Color(64, 64, 128);

    public Component getTableCellRendererComponent(JTable table, Object value,
            boolean isSelected, boolean hasFocus, int row, int column) {
        // Label erzeugen
        JLabel label = getLabel();
        StringBuffer tmpBuf = getStringBuffer();
        tmpBuf.setLength(0);
        tmpBuf.append(String.valueOf(value));
        label.setOpaque(true);
        Border b = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        label.setBorder(b);
        label.setFont(table.getFont());
        label.setForeground(table.getForeground());
        label.setBackground(table.getBackground());
        if (hasFocus) {
            label.setBackground(darkBlue);
            label.setForeground(Color.white);
        } else if (isSelected) {
            label.setBackground(lightBlue);
        }
        // Angezeigte Spalte in Modellspalte umwandeln
        // column = table.convertColumnIndexToModel(column);
        GAufnahmeIF tmpAufnahme = null;
        Icon tmpIcon = null;
        if (value instanceof GAufnahmeIF) {
            tmpAufnahme = (GAufnahmeIF) value;
        } else if (value instanceof GAufnahmeContainer) {
            GAufnahmeContainer tmpContainer = (GAufnahmeContainer) value;
            tmpAufnahme = tmpContainer.getAufnahme();
            if (tmpContainer.isExpandedDouble()) {
                tmpIcon = getLeafIcon();
            } else if (tmpContainer.hasChildren()) {
                if (tmpContainer.isExpanded()) {
                    tmpIcon = getExpandedIcon();
                } else {
                    tmpIcon = getCollapsedIcon();
                }
            } else {
                tmpBuf.insert(0, "   ");
            }
        }
        if (tmpAufnahme != null) {
            Color tmpColor = null;
            if (tmpAufnahme.getByte() < 0) {
                tmpColor = Color.blue;
            } else if (tmpAufnahme.isFehlerhaft()) {
                tmpColor = Color.red;
            } else if (tmpAufnahme.isLaufend()) {
                tmpColor = Color.red;
            }
            if (tmpColor != null) {
                label.setForeground(tmpColor);
            }
        }
        label.setIcon(tmpIcon);
        label.setText(tmpBuf.toString());
        return label;
    }

    /**
     * @return label
     */
    private JLabel getLabel() {
        if (aLabel == null) {
            aLabel = new JLabel();
        }
        return aLabel;
    }

    /**
     * @return stringBuffer
     */
    private StringBuffer getStringBuffer() {
        if (aStringBuffer == null) {
            aStringBuffer = new StringBuffer();
        }
        return aStringBuffer;
    }

    /**
     * Returns the default icon, for the current laf, that is used to represent
     * non-leaf nodes that are expanded.
     */
    private Icon getExpandedIcon() {
        if (expandedIcon == null) {
            expandedIcon = UIManager.getIcon("Tree.expandedIcon");
        }
        return expandedIcon;
    }

    /**
     * Returns the default icon, for the current laf, that is used to represent
     * non-leaf nodes that are not expanded.
     */
    private Icon getCollapsedIcon() {
        if (collapsedIcon == null) {
            collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
        }
        return collapsedIcon;
    }

    /**
     * Returns the default icon, for the current laf, that is used to represent
     * leaf nodes.
     */
    private Icon getLeafIcon() {
        if (leafIcon == null) {
            leafIcon = new ChildIcon();
        }
        return leafIcon;
    }

    /**
     * @return defaultLeafIcon
     */
    protected Icon getDefaultLeafIcon() {
        if (defaultLeafIcon == null) {
            defaultLeafIcon = UIManager.getIcon("Tree.leafIcon");
        }
        return defaultLeafIcon;
    }

    /**
     * @param inpLeafIcon
     *            Festzulegender leafIcon
     */
    protected void setLeafIcon(Icon inpLeafIcon) {
        leafIcon = inpLeafIcon;
    }

}